#!/usr/bin/python
# -*- coding: utf-8 -*-


def doDrawing(participants):
    import random
    from collections import deque

    exclusionmap = dict((name, exclusion) for (name, (email, exclusion)) in participants.iteritems()) 

    givers = list(participants)
    recipients = deque()

    pool = list(givers)
    hold = None
    exclusionHold = None

    if len(givers) < 2:
        return zip(givers, givers)

    for name in givers:
        if name in pool:
            hold = name
            pool.remove(hold)
        if exclusionmap[name] in pool:
            exclusionHold = exclusionmap[name]
            pool.remove(exclusionHold)
        if not pool:
            pick = recipients.pop()
            recipients.append(hold)
        else:
            pick = random.choice(pool)
            pool.remove(pick)
        recipients.append(pick)
        if hold:
            pool.append(hold)
            hold = None
        if exclusionHold:
            pool.append(exclusionHold)
            exclusionHold = None
    return zip(givers, recipients)


def printResults(participants, matches):
    for (giver, recipient) in matches:
        print 'Would email %s (at %s) to inform him/her that s/he should buy for %s' \
            % (giver, participants[giver][0], recipient)


def emailChoices(participants, matches):
    import smtplib
    import hmac
    import base64
    from urllib import urlencode
    mailer = smtplib.SMTP()
    print mailer.connect()
    subject = '//TEST// Name drawing result for gift exchange. //TEST//'

    for (giver, recipient) in matches:
        fromaddress="Christmas Name Drawing <do-not-reply@david.geoffrions.com>"
        recipient="ONLYATEST"
        messagebody = \
            '''From: %s
Subject: %s
Content-type: text/html; charset=utf-8

<html><body>Dear %s,<br /><br />
The following name has been drawn for you in relation to the upcoming gift exchange: %s<br /><br />
Merry Christmas!<br />
Click <a href="https://xmas.geoffrions.com/wishlist.php?%s">here</a> to view %s\'s wishlist.</body></html>''' \
            % (fromaddress, subject, giver, recipient, urlencode({'u': recipient}), recipient)
        mailer.sendmail(fromaddress,
                        participants[giver][0], messagebody)
        print 'mailing %s (%s)' % (giver, participants[giver][0])
    mailer.quit()

        # print 'Message:', messagebody

if __name__ == '__main__':
    from sys import argv, exit
    from os import path
    cmdname=path.basename(argv.pop(0))
    sendmail = False
    if argv and argv[0].startswith('--h'):
        print "Usage: %s [--help | --email] [csvfile ...]\n\nDo a name drawing based on an optional CSV file (or files) specifying giver name, email, and exclusion list\n\nOptions:\n  --help\t\tPrints this message\n  --email\t\tInvisibly email participants about choices made (otherwise, it operates in \"dry run\" mode)\n" % cmdname
        exit(0)
    if argv and argv[0].startswith('--e'):
        argv.pop(0)
        sendmail = True
    if len(argv) < 1:
        participants = {
            'Bob': ('bob@example.com', 'Chloë'),
            'Xander': ('xander@example.com', 'Reginald Feldgrün'),
            'Chloë': ('chloe@example.com', 'Bob'),
            'Reginald Feldgrün': ('rfeldgrun@example.com', 'Xander')
            }
        if sendmail:
            print 'Cowardly refusing to send email to example addresses'
        printResults(participants, doDrawing(participants))
    else:
        import csv
        for filelist in argv:
            if len(argv) > 1:
                print filelist \
                    + '\n-----------------------------------------------'
            namereader = csv.reader(open(filelist, 'rb'))
            participants = dict((name.strip(), (email.strip(), exclusion.strip()))
                                for (name, email, exclusion) in namereader)
            if sendmail:
                emailChoices(participants, doDrawing(participants))
            else:
                printResults(participants, doDrawing(participants))
            print

